/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware;

import jace.apple2e.SoftSwitches;
import jace.core.Computer;
import jace.core.Keyboard;
import jace.core.RAMEvent;
import jace.core.RAMListener;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConsoleProbe {
    public static boolean enabled = true;
    public String[] lastScreen = new String[24];
    public List<Rectangle> regions = new ArrayList<Rectangle>();
    private RAMListener textListener;
    public static long lastChange;
    public static long updateDelay;
    public static boolean readerActive;
    public Computer computer;
    private Thread keyReaderThread;

    public void init(Computer c) {
        this.computer = c;
        enabled = true;
        this.keyReaderThread = new Thread(new KeyReader());
        this.keyReaderThread.start();
        this.textListener = new RAMListener(RAMEvent.TYPE.WRITE, RAMEvent.SCOPE.RANGE, RAMEvent.VALUE.ANY){

            protected void doConfig() {
                this.setScopeStart(1024);
                this.setScopeEnd(3071);
            }

            protected void doEvent(RAMEvent e) {
                if (e.getAddress() < 2048 && SoftSwitches.PAGE2.isOn()) {
                    return;
                }
                if (SoftSwitches.TEXT.isOff()) {
                    if (SoftSwitches.MIXED.isOn()) {
                        this.handleMixedMode();
                    }
                } else {
                    this.handleTextMode();
                }
            }

            private void handleMixedMode() {
                this.handleTextMode();
            }

            private void handleTextMode() {
                lastChange = System.currentTimeMillis();
                if (readerActive) {
                    return;
                }
                Thread t = new Thread(new ScreenReader());
                t.start();
            }
        };
        c.getMemory().addListener(this.textListener);
    }

    public static synchronized void performRead() {
    }

    public void shutdown() {
        enabled = false;
        if (this.textListener != null) {
            this.computer.getMemory().removeListener(this.textListener);
        }
        if (this.keyReaderThread != null && this.keyReaderThread.isAlive()) {
            try {
                this.keyReaderThread.join();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ConsoleProbe.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    static {
        updateDelay = 100L;
        readerActive = false;
    }

    public static class KeyReader
    implements Runnable {
        public Computer c;

        public void run() {
            while (true) {
                try {
                    while (true) {
                        if (enabled && (System.in.available() == 0 || Keyboard.readState() < 0)) {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException ex) {
                                System.out.println(ex.getMessage());
                                Logger.getLogger(ConsoleProbe.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            continue;
                        }
                        if (!enabled) {
                            return;
                        }
                        int ch = System.in.read();
                        if (ch == 10) {
                            ch = 13;
                        }
                        Keyboard.pressKey((byte)ch);
                    }
                }
                catch (IOException ex) {
                    System.out.println(ex.getMessage());
                    Logger.getLogger(ConsoleProbe.class.getName()).log(Level.SEVERE, null, ex);
                    continue;
                }
                break;
            }
        }
    }

    public static class ScreenReader
    implements Runnable {
        public void run() {
            readerActive = true;
            try {
                long delay = 0L;
                while (System.currentTimeMillis() - lastChange <= updateDelay) {
                    delay = updateDelay - System.currentTimeMillis() - lastChange;
                    if (delay <= 0L) continue;
                    Thread.sleep(delay);
                }
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ConsoleProbe.class.getName()).log(Level.SEVERE, null, ex);
            }
            readerActive = false;
            ConsoleProbe.performRead();
        }
    }
}

